#ifndef __BDTYPES_H__
#define __BDTYPES_H__

// Win32
#ifdef WIN32

#define __MSC__
#include <windows.h>

// ANSI
#else

#include <signal.h>

typedef void* HANDLE;
//typedef long BOOL;
typedef unsigned char BYTE;
typedef unsigned short WORD;

#endif
// End System dependant

#include <glide.h>
#include <midasdll.h>
#include "resource.h"

//////////////////////////////////////////////////////////
// Types
//////////////////////////////////////////////////////////

#define FALSE 0
#define TRUE 1
#define false 0
#define true 1
#define PI2 (3.14159265359f * 2.f)
#define PI (3.14159265359f)

// Music state
typedef enum
{
	MusicNothing,
	MusicStartup,
	MusicInit,
	MusicBackground,
	MusicLoadModule,
	MusicPlay
}MusicState;

// Demo state data
typedef struct _DemoState_
{
	HANDLE hInstance;
	BOOL bDemoLoop;
	BOOL MaxPriority;
	BOOL NoSoundMode;
	BOOL DirectSound;
	BOOL TwoMonitors;
	BYTE MidasVolume;
	MusicState musicstate;
	HANDLE hwnd;
	int Frame;
	DWORD BeginTick, EndTick;
	MIDASmodule module;
	MIDASmodulePlayHandle playHandle;
	DWORD ClearColor;
	DWORD CurrEffect;
	DWORD ThisTick;
	DWORD TickInEffect;
	DWORD StartOfEffect;
	DWORD StartOfPattern;
	DWORD TickInPattern;
	DWORD PreviousPattern;
	BOOL AltTabQuit;
	DWORD dwPriority;
	float fLight;
	BOOL VideoFlo;
	MIDASplayStatus midas_status;
}DemoState;

// Vector definition
typedef struct _Vector_
{
	float x, y, z;
}Vector;

// IntVector definition
typedef struct _IntVector_
{
	float x, y, z;
}IntVector;


// Face definition
typedef struct _Face_
{
	unsigned int A,B,C;
	float SowA, TowA, SowB, TowB, SowC, TowC;
	float xNorm, yNorm, zNorm;
	BOOL IsVisible;
}Face;

// Simple face definition
typedef struct _SimpleFace_
{
	unsigned int A,B,C;
}SimpleFace;

// My vertex definition
typedef struct
{
  float x, y, z;                /* X, Y, and Z of scrn space -- Z is ignored */
  float r, g, b;                /* R, G, B, ([0..255.0]) */
  float ooz;                    /* 65535/Z (used for Z-buffering) */
  float a;                      /* Alpha [0..255.0] */
  float oow;                    /* 1/W (used for W-buffering, texturing) */
  GrTmuVertex  tmuvtx[GLIDE_NUM_TMU];
  float xNorm, yNorm, zNorm;
} FbVertex;

// 3d object definition
typedef struct _Obj3d_{
	FbVertex* pVertexIn;
	GrVertex* pVertexOut;
	unsigned int NbVertex;
	Face *pFace;
	unsigned int NbFaces;
}Obj3d;

// Voodoo texture definition
typedef struct _JpegTexture_{
	GrChipID_t tmu;
	FxU32 start;
	FxU32 evenOdd;
	GrTexInfo info;
	int width, height;
}JpegTexture;

typedef struct _Vertex_{
	float x,y,z;
	float s, t;
}Vertex;

// Effect function definition
typedef void (DEMO_PROC)();

// Effect structure definition
typedef struct{
	DEMO_PROC *LInit;
	DEMO_PROC *QInit;
	DEMO_PROC *Effect;
	DEMO_PROC *ByeBye;
	DWORD PatternMax;
	BOOL IsActive;
}DemoTiming;

// Simple types definition
typedef WORD* Picture;

#endif
